/*
 * Decompiled with CFR 0.152.
 */
package ImageResize;

import ImageResize.OpenedImages;
import java.awt.AlphaComposite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.control.TableView;
import javafx.scene.paint.Color;
import javafx.scene.text.Text;
import javax.imageio.ImageIO;

public class Worker {
    private DecimalFormat df = new DecimalFormat("0.00");
    private List<File> fList;
    TableView tblResizedFilesMod;
    HashMap<String, Boolean> resizeParams;
    HashMap<String, Integer> watermarkParams;
    Text textWM;
    int resizeScale;
    java.awt.Color textColor;
    BufferedImage watermarkImage = null;

    public Worker() {
    }

    public Worker(List<File> fileList, int rScale, TableView tableView, HashMap<String, Boolean> params, Text text) {
        this.fList = fileList;
        this.tblResizedFilesMod = tableView;
        this.resizeParams = params;
        this.textWM = text;
        this.resizeScale = rScale;
        if (this.resizeParams.get("textWater").booleanValue()) {
            this.textColor = this.getTextColor();
        }
    }

    public Worker(List<File> fileList, int rScale, TableView tableView, HashMap<String, Boolean> params, Text text, HashMap<String, Integer> paramsWM) {
        this.fList = fileList;
        this.tblResizedFilesMod = tableView;
        this.resizeParams = params;
        this.textWM = text;
        this.resizeScale = rScale;
        this.watermarkParams = paramsWM;
        if (this.resizeParams.get("textWater").booleanValue()) {
            this.textColor = this.getTextColor();
        }
    }

    public Worker(List<File> fileList, int rScale, TableView tableView, HashMap<String, Boolean> params, Text text, javafx.scene.image.Image wmImage, HashMap<String, Integer> paramsWM) {
        this.fList = fileList;
        this.tblResizedFilesMod = tableView;
        this.resizeParams = params;
        this.textWM = text;
        this.resizeScale = rScale;
        this.watermarkImage = SwingFXUtils.fromFXImage((javafx.scene.image.Image)wmImage, null);
        this.watermarkParams = paramsWM;
        if (this.resizeParams.get("textWater").booleanValue()) {
            this.textColor = this.getTextColor();
        }
    }

    public Task createWorker() {
        return new Task(){

            protected Object call() throws Exception {
                int i = 0;
                float[] createFilesTableTitleArray = new float[2];
                for (File file : Worker.this.fList) {
                    int width = 0;
                    int height = 0;
                    BufferedImage inputImg = null;
                    BufferedImage outputImg = null;
                    BufferedImage outputImgTmp = null;
                    File createFile = null;
                    try {
                        inputImg = ImageIO.read(file);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    if (inputImg != null) {
                        if (Worker.this.resizeParams.get("slider").booleanValue()) {
                            width = inputImg.getWidth() * Worker.this.resizeScale / 100;
                            height = inputImg.getHeight() * Worker.this.resizeScale / 100;
                            createFile = new File(file.getParent() + "/" + Worker.this.getFileName(file) + "_" + Worker.this.resizeScale + "_pc." + Worker.this.getFileExtension(file));
                        } else if (Worker.this.resizeParams.get("width").booleanValue()) {
                            width = Worker.this.resizeScale;
                            float ratio = (float)inputImg.getWidth() / (float)Worker.this.resizeScale;
                            height = (int)((float)inputImg.getHeight() / ratio);
                            createFile = new File(file.getParent() + "/" + Worker.this.getFileName(file) + "_" + Worker.this.resizeScale + "_W_px." + Worker.this.getFileExtension(file));
                        } else {
                            height = Worker.this.resizeScale;
                            float ratio = (float)inputImg.getHeight() / (float)Worker.this.resizeScale;
                            width = (int)((float)inputImg.getWidth() / ratio);
                            createFile = new File(file.getParent() + "/" + Worker.this.getFileName(file) + "_" + Worker.this.resizeScale + "_H_px." + Worker.this.getFileExtension(file));
                        }
                        if (Worker.this.resizeParams.get("textWater").booleanValue() && !Worker.this.resizeParams.get("imageWater").booleanValue()) {
                            outputImgTmp = Worker.this.resize(inputImg, height, width);
                            outputImg = Worker.this.addTextWatermark(Worker.this.textWM, Worker.this.getFileExtension(file), outputImgTmp);
                        } else if (!Worker.this.resizeParams.get("textWater").booleanValue() && Worker.this.resizeParams.get("imageWater").booleanValue()) {
                            outputImgTmp = Worker.this.resize(inputImg, height, width);
                            outputImg = Worker.this.addImageWatermark(Worker.this.watermarkImage, Worker.this.getFileExtension(file), outputImgTmp);
                        } else if (Worker.this.resizeParams.get("textWater").booleanValue() && Worker.this.resizeParams.get("imageWater").booleanValue()) {
                            outputImgTmp = Worker.this.resize(inputImg, height, width);
                            outputImg = Worker.this.addImageAndTextWatermark(Worker.this.watermarkImage, Worker.this.textWM, Worker.this.getFileExtension(file), outputImgTmp);
                        } else {
                            outputImg = Worker.this.resize(inputImg, height, width);
                        }
                        String createFileName = createFile.getName();
                        try {
                            ImageIO.write((RenderedImage)outputImg, Worker.this.getFileExtension(file), createFile);
                        }
                        catch (Exception e1) {
                            createFileName = "Sikertelen m\u0171velet";
                            e1.printStackTrace();
                        }
                        Worker.this.tblResizedFilesMod.getItems().add((Object)new OpenedImages(createFileName, Worker.this.df.format(createFile.length() / 1024L)));
                        createFilesTableTitleArray[0] = ++i;
                        createFilesTableTitleArray[1] = createFilesTableTitleArray[1] + (float)createFile.length();
                    }
                    this.updateMessage("Ready.");
                    this.updateValue(createFilesTableTitleArray);
                    this.updateProgress(i, Worker.this.fList.size());
                }
                return true;
            }
        };
    }

    private BufferedImage addImageWatermark(BufferedImage watermark, String type, BufferedImage source) throws IOException {
        BufferedImage image = source;
        BufferedImage overlay = this.resize(watermark, this.watermarkParams.get("height"), this.watermarkParams.get("width"));
        int imageType = "png".equalsIgnoreCase(type) ? 2 : 1;
        BufferedImage watermarked = new BufferedImage(image.getWidth(), image.getHeight(), imageType);
        Graphics2D w = (Graphics2D)watermarked.getGraphics();
        w.drawImage((Image)image, 0, 0, null);
        AlphaComposite alphaChannel = AlphaComposite.getInstance(3, (float)this.watermarkParams.get("opacity").intValue() / 10.0f);
        w.setComposite(alphaChannel);
        w.drawImage((Image)overlay, this.getX(image, overlay), this.getY(image, overlay), null);
        w.dispose();
        return watermarked;
    }

    private BufferedImage addImageAndTextWatermark(BufferedImage watermark, Text textWM, String type, BufferedImage source) throws IOException {
        int tY = 0;
        BufferedImage image = source;
        BufferedImage overlay = this.resize(watermark, this.watermarkParams.get("height"), this.watermarkParams.get("width"));
        int imageType = "png".equalsIgnoreCase(type) ? 2 : 1;
        BufferedImage watermarked = new BufferedImage(image.getWidth(), image.getHeight(), imageType);
        Graphics2D w = (Graphics2D)watermarked.getGraphics();
        w.drawImage((Image)image, 0, 0, null);
        AlphaComposite alphaChannel = AlphaComposite.getInstance(3, (float)this.watermarkParams.get("opacity").intValue() / 10.0f);
        w.setComposite(alphaChannel);
        w.setColor(this.textColor);
        if (textWM.getFont().getStyle() == "Bold") {
            w.setFont(new Font(textWM.getFont().getFamily(), 1, (int)textWM.getFont().getSize()));
        } else {
            w.setFont(new Font(textWM.getFont().getFamily(), 0, (int)textWM.getFont().getSize()));
        }
        FontMetrics fontMetrics = w.getFontMetrics();
        Rectangle2D rect = fontMetrics.getStringBounds(textWM.getText(), w);
        switch (this.watermarkParams.get("WMpos")) {
            case 1: {
                int iY;
                int iX = 10;
                int tX = iX + overlay.getWidth() + 10;
                if (overlay.getHeight() > (int)(rect.getHeight() * 0.8)) {
                    iY = 10;
                    tY = overlay.getHeight() / 2 - this.getY(image, rect) / 2 + this.getY(image, rect);
                } else {
                    iY = this.getY(image, rect) / 2 - overlay.getHeight() / 2 + this.getY(image, overlay);
                    tY = this.getY(image, rect);
                }
                w.drawImage((Image)overlay, iX, iY, null);
                w.drawString(textWM.getText(), tX, tY);
                break;
            }
            case 2: {
                int iY;
                int iX = image.getWidth() - (overlay.getWidth() + (int)rect.getWidth()) - 20;
                int tX = image.getWidth() - (int)rect.getWidth() - 10;
                if (overlay.getHeight() > (int)(rect.getHeight() * 0.8)) {
                    iY = 10;
                    tY = overlay.getHeight() / 2 - this.getY(image, rect) / 2 + this.getY(image, rect);
                } else {
                    iY = this.getY(image, rect) / 2 - overlay.getHeight() / 2 + this.getY(image, overlay);
                    tY = this.getY(image, rect);
                }
                w.drawImage((Image)overlay, iX, iY, null);
                w.drawString(textWM.getText(), tX, tY);
                break;
            }
            case 3: {
                int iY;
                int iX = image.getWidth() / 2 - (overlay.getWidth() + 10 + (int)rect.getWidth()) / 2;
                int tX = iX + 10 + overlay.getWidth();
                if (overlay.getHeight() > (int)(rect.getHeight() * 0.8)) {
                    iY = this.getY(image, overlay);
                    tY = this.getY(image, rect);
                } else {
                    iY = this.getY(image, overlay);
                    tY = this.getY(image, rect);
                }
                w.drawImage((Image)overlay, iX, iY, null);
                w.drawString(textWM.getText(), tX, tY);
                break;
            }
            case 4: {
                int iY;
                int iX = 10;
                int tX = iX + overlay.getWidth() + 10;
                if (overlay.getHeight() > (int)(rect.getHeight() * 0.8)) {
                    iY = this.getY(image, overlay);
                    tY = this.getY(image, rect) - 10 - (overlay.getHeight() / 2 - (int)(rect.getHeight() * 0.8 / 2.0));
                } else {
                    iY = image.getHeight() - ((int)(rect.getHeight() * 0.8 / 2.0) + overlay.getHeight() / 2);
                    tY = this.getY(image, rect);
                }
                w.drawImage((Image)overlay, iX, iY, null);
                w.drawString(textWM.getText(), tX, tY);
                break;
            }
            case 5: {
                int iY;
                int iX = image.getWidth() - (overlay.getWidth() + (int)rect.getWidth()) - 20;
                int tX = image.getWidth() - (int)rect.getWidth() - 10;
                if (overlay.getHeight() > (int)(rect.getHeight() * 0.8)) {
                    iY = this.getY(image, overlay);
                    tY = this.getY(image, rect) - 10 - (overlay.getHeight() / 2 - (int)(rect.getHeight() * 0.8 / 2.0));
                } else {
                    iY = image.getHeight() - ((int)(rect.getHeight() * 0.8 / 2.0) + overlay.getHeight() / 2);
                    tY = this.getY(image, rect);
                }
                w.drawImage((Image)overlay, iX, iY, null);
                w.drawString(textWM.getText(), tX, tY);
            }
        }
        w.dispose();
        return watermarked;
    }

    private BufferedImage addTextWatermark(Text textWM, String type, BufferedImage source) throws IOException {
        BufferedImage image = source;
        int imageType = "png".equalsIgnoreCase(type) ? 2 : 1;
        BufferedImage watermarked = new BufferedImage(image.getWidth(), image.getHeight(), imageType);
        Graphics2D w = (Graphics2D)watermarked.getGraphics();
        w.drawImage((Image)image, 0, 0, null);
        AlphaComposite alphaChannel = AlphaComposite.getInstance(3, (float)this.watermarkParams.get("opacity").intValue() / 10.0f);
        w.setComposite(alphaChannel);
        w.setColor(this.textColor);
        if (textWM.getFont().getStyle() == "Bold") {
            w.setFont(new Font(textWM.getFont().getFamily(), 1, (int)textWM.getFont().getSize()));
        } else {
            w.setFont(new Font(textWM.getFont().getFamily(), 0, (int)textWM.getFont().getSize()));
        }
        FontMetrics fontMetrics = w.getFontMetrics();
        Rectangle2D rect = fontMetrics.getStringBounds(textWM.getText(), w);
        w.drawString(textWM.getText(), this.getX(image, rect), this.getY(image, rect));
        w.dispose();
        return watermarked;
    }

    private BufferedImage resize(BufferedImage img, int height, int width) {
        Image tmp = img.getScaledInstance(width, height, 4);
        BufferedImage resized = new BufferedImage(width, height, img.getType());
        Graphics2D g2d = resized.createGraphics();
        g2d.drawImage(tmp, 0, 0, null);
        g2d.dispose();
        return resized;
    }

    private int getX(BufferedImage image, Rectangle2D rectangle) {
        int x = 0;
        switch (this.watermarkParams.get("WMpos")) {
            case 1: {
                x = 10;
                break;
            }
            case 2: {
                x = image.getWidth() - (int)rectangle.getWidth();
                break;
            }
            case 3: {
                x = (image.getWidth() - (int)rectangle.getWidth()) / 2;
                break;
            }
            case 4: {
                x = 10;
                break;
            }
            case 5: {
                x = image.getWidth() - (int)rectangle.getWidth() - 10;
            }
        }
        return x;
    }

    private int getY(BufferedImage image, Rectangle2D rectangle) {
        int y = 0;
        switch (this.watermarkParams.get("WMpos")) {
            case 1: {
                y = (int)rectangle.getHeight() - (int)((double)((int)rectangle.getHeight()) * 0.2);
                break;
            }
            case 2: {
                y = (int)rectangle.getHeight() - (int)((double)((int)rectangle.getHeight()) * 0.2);
                break;
            }
            case 3: {
                y = image.getHeight() / 2 + (int)(rectangle.getHeight() * 0.8) / 2;
                break;
            }
            case 4: {
                y = image.getHeight() - 10;
            }
            case 5: {
                y = image.getHeight() - 10;
            }
        }
        return y;
    }

    private int getX(BufferedImage image, BufferedImage overlay) {
        int x = 0;
        switch (this.watermarkParams.get("WMpos")) {
            case 1: {
                x = 10;
                break;
            }
            case 2: {
                x = image.getWidth() - overlay.getWidth();
                break;
            }
            case 3: {
                x = (image.getWidth() - overlay.getWidth()) / 2;
                break;
            }
            case 4: {
                x = 10;
                break;
            }
            case 5: {
                x = image.getWidth() - overlay.getWidth() - 10;
            }
        }
        return x;
    }

    private int getY(BufferedImage image, BufferedImage overlay) {
        int y = 0;
        switch (this.watermarkParams.get("WMpos")) {
            case 1: {
                y = 10;
                break;
            }
            case 2: {
                y = 10;
                break;
            }
            case 3: {
                y = (image.getHeight() - overlay.getHeight()) / 2;
                break;
            }
            case 4: {
                y = image.getHeight() - overlay.getHeight() - 10;
                break;
            }
            case 5: {
                y = image.getHeight() - overlay.getHeight() - 10;
            }
        }
        return y;
    }

    private String getFileExtension(File file) {
        String fileName = file.getName();
        if (fileName.lastIndexOf(".") != -1 && fileName.lastIndexOf(".") != 0) {
            return fileName.substring(fileName.lastIndexOf(".") + 1);
        }
        return "ErvenytelenFileKiterjesztes";
    }

    private String getFileName(File file) {
        String fileName = file.getName();
        if (fileName.lastIndexOf(".") != -1 && fileName.lastIndexOf(".") != 0) {
            return fileName.substring(0, fileName.lastIndexOf("."));
        }
        return "ErvenytelenFileNev";
    }

    private java.awt.Color getTextColor() {
        Color c = (Color)this.textWM.getFill();
        return new java.awt.Color((int)(c.getRed() * 255.0), (int)(c.getGreen() * 255.0), (int)(c.getBlue() * 255.0));
    }
}

