/*
 * Decompiled with CFR 0.152.
 */
package ImageResize;

import ImageResize.OpenedImages;
import ImageResize.Tools;
import ImageResize.Worker;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.util.Callback;

public class ImageResizeController
implements Initializable {
    private List<File> fileList = null;
    private File watermarkImage;
    DecimalFormat df = new DecimalFormat("0.00");
    DecimalFormat dfInt = new DecimalFormat("0");
    private int resizeUserValue = 1024;
    private Task copyWorker;
    private float[] titles;
    FontWeight fontWeight = FontWeight.NORMAL;
    Text textWM = new Text("WaterMark..");
    Image inputWMImg = null;
    @FXML
    private Button btnOpenImages;
    @FXML
    private Button btnOpenImagesWaterMark;
    @FXML
    private Button btnResize;
    @FXML
    private Button btnDelete;
    @FXML
    private Button btnHelp;
    @FXML
    private TableView tblOpenedFiles;
    @FXML
    private TableView tblResizedFiles;
    @FXML
    private TableColumn fileName;
    @FXML
    private TableColumn fileSize;
    @FXML
    private TableColumn createFileName;
    @FXML
    private TableColumn createFileSize;
    @FXML
    private Label lblResizeRatio;
    @FXML
    private Label lblWatermarkImageName;
    @FXML
    private Label lblWatermarkWidth;
    @FXML
    private Label lblWatermarkHeight;
    @FXML
    private Slider sldrResize;
    @FXML
    private Slider sldrWatermark;
    @FXML
    private Slider sldrOpacity;
    @FXML
    private RadioButton rdbtnSlider;
    @FXML
    private RadioButton rdbtnManual;
    @FXML
    private ToggleGroup resizeCategory;
    @FXML
    private TextField txtfldResizeInput;
    @FXML
    private ToggleGroup resizeSide;
    @FXML
    private RadioButton rdbtnW;
    @FXML
    private RadioButton rdbtnH;
    @FXML
    private ToggleGroup watermarkPos;
    @FXML
    private RadioButton rdbtnWMPosC;
    @FXML
    private RadioButton rdbtnWMPosLT;
    @FXML
    private RadioButton rdbtnWMPosRT;
    @FXML
    private RadioButton rdbtnWMPosLB;
    @FXML
    private RadioButton rdbtnWMPosRB;
    @FXML
    private ProgressBar pBar;
    @FXML
    private CheckBox chckboxTextWater;
    @FXML
    private CheckBox chckboxImageWater;
    @FXML
    private ComboBox<String> cmbboxFontType;
    @FXML
    private ComboBox<Integer> cmbboxFontSize;
    @FXML
    private ColorPicker clrFontColor;
    @FXML
    private TextField txtfldWaterMark;
    @FXML
    private Pane paneText;
    @FXML
    private StackPane stackPane;
    @FXML
    private TextFlow textFlow;
    @FXML
    private ToggleGroup weightGroup;
    @FXML
    private ToggleButton tglbtnNormal;
    @FXML
    private ToggleButton tglbtnBold;
    @FXML
    private ImageView imgvwWatermark;
    @FXML
    private ImageView iwLogo;

    @FXML
    private void openImages(ActionEvent event) {
        int filesCount = 0;
        float filesSizeSum = 0.0f;
        this.defaultState();
        this.fileList = Tools.openFiles(this.btnOpenImages.getScene().getWindow());
        if (this.fileList != null && this.fileList.size() != 0) {
            for (File file : this.fileList) {
                ++filesCount;
                filesSizeSum += (float)file.length();
                this.tblOpenedFiles.getItems().add((Object)new OpenedImages(file.getName(), this.df.format(file.length() / 1024L)));
            }
            this.fileName.setText("F\u00e1jl n\u00e9v ( " + filesCount + " )");
            this.fileSize.setText("M\u00e9ret (" + this.df.format(filesSizeSum / 1048576.0f) + " MB)");
        }
    }

    @FXML
    private void openWatermarkImages() {
        this.watermarkImage = Tools.openWaterMarkFile(this.btnOpenImagesWaterMark.getScene().getWindow());
        if (this.watermarkImage != null) {
            this.lblWatermarkImageName.setText(this.watermarkImage.getName());
            try {
                FileInputStream input = new FileInputStream(this.watermarkImage);
                this.inputWMImg = new Image((InputStream)input);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            this.imgvwWatermark.setImage(this.inputWMImg);
            this.lblWatermarkWidth.setText((int)this.inputWMImg.getWidth() + "");
            this.lblWatermarkHeight.setText((int)this.inputWMImg.getHeight() + "");
        }
    }

    @FXML
    private void openedImagesResize(ActionEvent event) {
        this.tblResizedFiles.getItems().clear();
        HashMap<String, Boolean> resizeParams = new HashMap<String, Boolean>();
        HashMap<String, Integer> watermarkParams = new HashMap<String, Integer>();
        int resizeScale = 0;
        if (this.fileList == null || this.fileList.size() == 0) {
            Tools.noImages(this.btnResize.getScene().getWindow());
            return;
        }
        if (this.resizeCategory.getSelectedToggle() == this.rdbtnManual && this.txtfldResizeInput.getText() != null && !this.txtfldResizeInput.getText().isEmpty()) {
            int savedValue = Integer.parseInt(this.txtfldResizeInput.getText());
            if (savedValue >= 10 && savedValue <= 4096) {
                this.resizeUserValue = savedValue;
            } else {
                Tools.ownAlert(savedValue, this.btnResize.getScene().getWindow());
                this.txtfldResizeInput.setText("1024");
                return;
            }
        }
        for (File file : this.fileList) {
            if (file.canRead()) continue;
            Tools.noRead(file.getName(), this.btnResize.getScene().getWindow());
            this.defaultState();
            return;
        }
        this.buttonDisabled();
        if (this.resizeCategory.getSelectedToggle() == this.rdbtnSlider) {
            resizeParams.put("slider", true);
            resizeScale = (int)this.sldrResize.getValue();
        } else if (this.resizeSide.getSelectedToggle() == this.rdbtnW) {
            resizeParams.put("width", true);
            resizeScale = this.resizeUserValue;
        } else {
            resizeScale = this.resizeUserValue;
        }
        resizeParams.put("textWater", false);
        resizeParams.put("imageWater", false);
        resizeParams.put("slider", this.resizeCategory.getSelectedToggle() == this.rdbtnSlider);
        resizeParams.put("width", this.resizeSide.getSelectedToggle() == this.rdbtnW);
        this.copyWorker = null;
        if (this.chckboxImageWater.isSelected() || this.chckboxTextWater.isSelected()) {
            if (this.chckboxImageWater.isSelected()) {
                resizeParams.put("imageWater", true);
                watermarkParams.put("width", Integer.parseInt(this.lblWatermarkWidth.getText()));
                watermarkParams.put("height", Integer.parseInt(this.lblWatermarkHeight.getText()));
            }
            if (this.chckboxTextWater.isSelected()) {
                resizeParams.put("textWater", true);
            }
            watermarkParams.put("opacity", (int)((float)this.sldrOpacity.getValue() * 10.0f));
            if (this.watermarkPos.getSelectedToggle() == this.rdbtnWMPosLT) {
                watermarkParams.put("WMpos", 1);
            } else if (this.watermarkPos.getSelectedToggle() == this.rdbtnWMPosRT) {
                watermarkParams.put("WMpos", 2);
            } else if (this.watermarkPos.getSelectedToggle() == this.rdbtnWMPosC) {
                watermarkParams.put("WMpos", 3);
            } else if (this.watermarkPos.getSelectedToggle() == this.rdbtnWMPosLB) {
                watermarkParams.put("WMpos", 4);
            } else {
                watermarkParams.put("WMpos", 5);
            }
            this.copyWorker = this.chckboxImageWater.isSelected() && this.chckboxTextWater.isSelected() || this.chckboxImageWater.isSelected() ? new Worker(this.fileList, resizeScale, this.tblResizedFiles, resizeParams, this.textPreview(), this.inputWMImg, watermarkParams).createWorker() : new Worker(this.fileList, resizeScale, this.tblResizedFiles, resizeParams, this.textPreview(), watermarkParams).createWorker();
        } else {
            this.copyWorker = new Worker(this.fileList, resizeScale, this.tblResizedFiles, resizeParams, this.textPreview()).createWorker();
        }
        this.pBar.progressProperty().unbind();
        this.pBar.progressProperty().bind((ObservableValue)this.copyWorker.progressProperty());
        this.copyWorker.messageProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                ImageResizeController.this.copyWorker.setOnSucceeded(event -> {
                    ImageResizeController.this.buttonEnabled();
                    ImageResizeController.this.createFileName.setText("F\u00e1jl n\u00e9v ( " + ImageResizeController.this.dfInt.format(ImageResizeController.this.titles[0]) + " )");
                    ImageResizeController.this.createFileSize.setText("M\u00e9ret (" + ImageResizeController.this.df.format(ImageResizeController.this.titles[1] / 1048576.0f) + " MB)");
                    if ((int)ImageResizeController.this.titles[0] != ImageResizeController.this.fileList.size()) {
                        Tools.defError(ImageResizeController.this.btnResize.getScene().getWindow());
                    }
                    System.out.println("k\u00e9sz");
                });
            }
        });
        this.copyWorker.valueProperty().addListener((o, oldValue, newValue) -> {
            if (newValue != null && Tools.isArray(newValue)) {
                this.titles = (float[])newValue;
            }
        });
        new Thread((Runnable)this.copyWorker).start();
    }

    @FXML
    private void deleteImages(ActionEvent event) {
        String dir = null;
        if (this.fileList == null || this.fileList.size() == 0) {
            Tools.noImages(this.btnDelete.getScene().getWindow());
            return;
        }
        if (Tools.confirmDelete(this.btnDelete.getScene().getWindow())) {
            boolean allDeleted = true;
            for (File file : this.fileList) {
                dir = file.getParent();
                try {
                    if (file.delete()) {
                        System.out.println(file.getName() + " is deleted!");
                        continue;
                    }
                    allDeleted = false;
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
            this.defaultState();
            if (!allDeleted) {
                Tools.failedDelete(dir, this.btnDelete.getScene().getWindow());
            }
        } else {
            return;
        }
    }

    @FXML
    private void showHelp() {
        StackPane secondaryLayout = new StackPane();
        Scene secondScene = new Scene((Parent)secondaryLayout, 1000.0, 700.0);
        Stage newWindow = new Stage();
        newWindow.initModality(Modality.APPLICATION_MODAL);
        newWindow.setTitle("S\u00fag\u00f3");
        newWindow.setScene(secondScene);
        newWindow.initOwner(this.btnHelp.getScene().getWindow());
        newWindow.show();
        URL url = this.getClass().getResource("help/help.html");
        WebView view = new WebView();
        WebEngine engine = view.getEngine();
        engine.load(url.toString());
        secondaryLayout.getChildren().add((Object)view);
    }

    @FXML
    private void showAbout() {
        Tools.about(this.iwLogo.getScene().getWindow());
    }

    @FXML
    private void changeFontType() {
        this.textPreview();
    }

    @FXML
    private void changeFontSize() {
        this.textPreview();
    }

    @FXML
    private void changeFontColor() {
        this.textPreview();
    }

    private void defaultState() {
        this.tblOpenedFiles.getItems().clear();
        this.tblResizedFiles.getItems().clear();
        this.fileName.setText("F\u00e1jl n\u00e9v");
        this.fileSize.setText("M\u00e9ret (MB)");
        this.createFileName.setText("F\u00e1jl n\u00e9v");
        this.createFileSize.setText("M\u00e9ret (MB)");
        this.fileList = null;
        this.pBar.progressProperty().unbind();
        this.pBar.setProgress(0.0);
    }

    private void buttonDisabled() {
        this.btnDelete.setDisable(true);
        this.btnResize.setDisable(true);
        this.btnOpenImages.setDisable(true);
        this.rdbtnSlider.setDisable(true);
        this.rdbtnManual.setDisable(true);
        this.rdbtnW.setDisable(true);
        this.rdbtnH.setDisable(true);
        this.txtfldResizeInput.setDisable(true);
    }

    private void buttonEnabled() {
        this.btnDelete.setDisable(false);
        this.btnResize.setDisable(false);
        this.btnOpenImages.setDisable(false);
        if (this.resizeCategory.getSelectedToggle() == this.rdbtnSlider) {
            this.rdbtnSlider.setDisable(false);
            this.rdbtnManual.setDisable(false);
        } else {
            this.rdbtnSlider.setDisable(false);
            this.rdbtnManual.setDisable(false);
            this.rdbtnW.setDisable(false);
            this.rdbtnH.setDisable(false);
            this.txtfldResizeInput.setDisable(false);
        }
    }

    private Text textPreview() {
        this.textWM.setText(this.txtfldWaterMark.getText());
        Font font = Font.font((String)((String)this.cmbboxFontType.getValue()), (FontWeight)this.fontWeight, (double)((Integer)this.cmbboxFontSize.getValue()).intValue());
        this.textWM.setFill((Paint)this.clrFontColor.getValue());
        this.textWM.setFont(font);
        this.textFlow.getChildren().clear();
        this.textFlow.getChildren().add((Object)this.textWM);
        return this.textWM;
    }

    private void baseImagePreview(OpenedImages oi) {
        File openedFile = null;
        for (File file : this.fileList) {
            if (!file.getName().equals(oi.getFileName())) continue;
            openedFile = file;
        }
        if (openedFile != null) {
            Tools.previewWindow(openedFile, this.tblOpenedFiles.getScene().getWindow());
        }
    }

    private void resizedImagePreview(OpenedImages oi) {
        File resizedFile;
        String path = "";
        Optional file = this.fileList.stream().findFirst();
        if (file.isPresent()) {
            path = ((File)file.get()).getParent();
        }
        if ((resizedFile = new File(path + File.separator + oi.getFileName())).exists() && !resizedFile.isDirectory()) {
            Tools.previewWindow(resizedFile, this.tblResizedFiles.getScene().getWindow());
        }
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.tblOpenedFiles.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent ee) {
                if (ee.isPrimaryButtonDown() && ee.getClickCount() == 2) {
                    OpenedImages oi = (OpenedImages)ImageResizeController.this.tblOpenedFiles.getSelectionModel().getSelectedItem();
                    ImageResizeController.this.baseImagePreview(oi);
                }
            }
        });
        this.tblResizedFiles.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent ee) {
                if (ee.isPrimaryButtonDown() && ee.getClickCount() == 2) {
                    OpenedImages oi = (OpenedImages)ImageResizeController.this.tblResizedFiles.getSelectionModel().getSelectedItem();
                    ImageResizeController.this.resizedImagePreview(oi);
                }
            }
        });
        this.sldrResize.setValue(80.0);
        this.lblResizeRatio.setText("80 %");
        this.sldrResize.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                int sliderRatio = (int)newValue.doubleValue();
                ImageResizeController.this.lblResizeRatio.setText("" + sliderRatio + " %");
            }
        });
        this.sldrWatermark.setValue(100.0);
        this.sldrWatermark.valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.inputWMImg != null) {
                this.lblWatermarkWidth.setText((int)(this.inputWMImg.getWidth() * (newValue.doubleValue() / 100.0)) + "");
                this.lblWatermarkHeight.setText((int)(this.inputWMImg.getHeight() * (newValue.doubleValue() / 100.0)) + "");
            }
        });
        this.sldrOpacity.setValue(0.5);
        this.chckboxImageWater.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue() && this.watermarkImage == null) {
                this.chckboxImageWater.setSelected(false);
                Tools.noImages(this.chckboxImageWater.getScene().getWindow());
            }
        });
        this.txtfldResizeInput.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d*")) {
                    ImageResizeController.this.txtfldResizeInput.setText(newValue.replaceAll("[^\\d]", ""));
                } else if (Integer.parseInt(newValue) < 1) {
                    ImageResizeController.this.txtfldResizeInput.setText("1");
                }
            }
        });
        this.resizeCategory.selectToggle((Toggle)this.rdbtnSlider);
        this.rdbtnW.setDisable(true);
        this.rdbtnH.setDisable(true);
        this.txtfldResizeInput.setDisable(true);
        this.resizeCategory.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> ov, Toggle old_toggle, Toggle new_toggle) {
                if (ImageResizeController.this.resizeCategory.getSelectedToggle() != null) {
                    if (ImageResizeController.this.resizeCategory.getSelectedToggle() == ImageResizeController.this.rdbtnSlider) {
                        ImageResizeController.this.sldrResize.setDisable(false);
                        ImageResizeController.this.rdbtnW.setDisable(true);
                        ImageResizeController.this.rdbtnH.setDisable(true);
                        ImageResizeController.this.txtfldResizeInput.setDisable(true);
                    } else {
                        ImageResizeController.this.sldrResize.setDisable(true);
                        ImageResizeController.this.rdbtnW.setDisable(false);
                        ImageResizeController.this.rdbtnH.setDisable(false);
                        ImageResizeController.this.txtfldResizeInput.setDisable(false);
                    }
                }
            }
        });
        this.cmbboxFontType.setItems(FXCollections.observableArrayList((Collection)Font.getFamilies()));
        for (int i = 8; i < 120; ++i) {
            this.cmbboxFontSize.getItems().add((Object)i);
        }
        this.cmbboxFontType.getSelectionModel().selectFirst();
        this.cmbboxFontSize.getSelectionModel().select(18);
        this.clrFontColor.setValue((Object)Color.BLACK);
        this.txtfldWaterMark.textProperty().addListener((observable, oldValue, newValue) -> this.textPreview());
        this.weightGroup.selectedToggleProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue == null) {
                oldValue.setSelected(true);
            }
            this.fontWeight = this.weightGroup.getSelectedToggle() == this.tglbtnNormal ? FontWeight.NORMAL : FontWeight.BOLD;
            this.textPreview();
        });
        this.textFlow.getChildren().add((Object)this.textWM);
        this.tblOpenedFiles.setEditable(false);
        this.fileName.setMinWidth(270.0);
        this.fileName.setCellValueFactory((Callback)new PropertyValueFactory("fileName"));
        this.fileSize.setMinWidth(190.0);
        this.fileSize.setCellValueFactory((Callback)new PropertyValueFactory("fileSize"));
        this.tblResizedFiles.setEditable(false);
        this.createFileName.setMinWidth(310.0);
        this.createFileName.setCellValueFactory((Callback)new PropertyValueFactory("fileName"));
        this.createFileSize.setMinWidth(150.0);
        this.createFileSize.setCellValueFactory((Callback)new PropertyValueFactory("fileSize"));
    }
}

